"""Metrics: visibility, distinguishability, confidence intervals."""
from __future__ import annotations
import numpy as np

def visibility(I_max: int, I_min: int) -> float:
    num = I_max - I_min
    den = I_max + I_min
    return 0.0 if den == 0 else float(num / den)

def tv_distance(p: np.ndarray, q: np.ndarray) -> float:
    p = np.asarray(p, dtype=float)
    q = np.asarray(q, dtype=float)
    p = p / p.sum()
    q = q / q.sum()
    return 0.5 * float(np.sum(np.abs(p - q)))

def bootstrap_ci(vals, alpha=0.32, B=1000, rng=None):
    vals = np.asarray(vals, dtype=float)
    if rng is None:
        rng = np.random.default_rng(0)
    N = len(vals)
    idx = rng.integers(0, N, size=(B, N))
    samples = vals[idx].mean(axis=1)
    lo = np.quantile(samples, 0.5 - alpha/2)
    hi = np.quantile(samples, 0.5 + alpha/2)
    return float(lo), float(hi)
